name_prefix = "inaba-wp-dev"

# ネットワーク ##############################################################################
vpc_args  = {
    cidr_block              = "10.0.0.0/16"
    instance_tenancy        = "default"
    enable_dns_support      = true
    enable_dns_hostnames    = true
    name_tag                = "vpc"
}

public_subnet_1a_args = {
    cidr_block          = "10.0.0.0/24"
    availability_zone   = "ap-northeast-1a"
    name_tag            = "public-subnet-1a"
}
private_subnet_1a_args = {
    cidr_block          = "10.0.2.0/24"
    availability_zone   = "ap-northeast-1a"
    name_tag            = "private-subnet-1a"
}
public_subnet_1c_args = {
    cidr_block          = "10.0.1.0/24"
    availability_zone   = "ap-northeast-1c"
    name_tag            = "public-subnet-1c"
}
private_subnet_1c_args = {
    cidr_block          = "10.0.3.0/24"
    availability_zone   = "ap-northeast-1c"
    name_tag            = "private-subnet-1c"
}

internet_gateway_name_tag = "igw"
route_table_to_internet_name_tag = "route_table_to_internet"


# EFS ###########################################################################################
efs_args = {
    name_tag            = "efs"
    performance_mode    = "generalPurpose"
    throughput_mode     = "elastic"
}
security_group_for_efs_args = {
    name_tag            = "security-group-for-efs"
    description         = "for efs"
}
security_group_ingress_for_efs_args = { 
    name_tag            = "ingress-rule-for-efs"
    ingress_from_port   = 2049
    ingress_to_port     = 2049
    ingress_protocol    = "tcp"
    ingress_cidr_ipv4   = null
}
security_group_egress_for_efs_args = {
    name_tag            = "egress-rule-for-efs"
    egress_from_port    = 0
    egress_to_port      = 0
    egress_protocol     = "-1"
    egress_cidr_ipv4    = "0.0.0.0/0"
}

# EC2 ####################################################################################
ec2_launch_template_args = {
    ami_id                      = "ami-03350e4f182961c7f" # Amazon Linux 2023 AMI
    instance_type               = "t3.medium"
    block_device_name           = "/dev/xvde" #ebsよくわからない　調べる
    ebs_volume_size             = "30"
    ebs_volume_type             = "gp3"
    ebs_delete_on_termination   = true
    instance_name_tag           = "wordpress-ec2"
    launch_template_name_tag    = "launch-template-for-wordpress-ec2"
}
security_group_for_ec2_args = {
    name_tag    = "security-group-for-ec2"
    description = "for ec2"
}
security_group_ingress_from_alb_for_ec2_args = { 
    name_tag            = "ingress-rule-from-alb-for-ec2"
    ingress_from_port   = 80
    ingress_to_port     = 80
    ingress_protocol    = "tcp"
    ingress_cidr_ipv4   = null
}
security_group_ingress_from_internet_for_ec2_args = { 
    name_tag            = "ingress-rule-from-internet-for-ec2"
    ingress_from_port   = 80
    ingress_to_port     = 80
    ingress_protocol    = "tcp"
    ingress_cidr_ipv4   = "xxx.xxx.xxx.xxx/32"# マイIP
}
security_group_egress_for_ec2_args = {
    name_tag            = "egress-rule-for-ec2"
    egress_from_port    = 0
    egress_to_port      = 0
    egress_protocol     = "-1"
    egress_cidr_ipv4    = "0.0.0.0/0"
}
ec2_role_settings_args = {
    instance_profile_name_tag   = "instance-profile-for-wordpress-ec2"
    iam_role_name_tag           = "iam-role-for-wordpress-ec2"
}


# alb ############################################################################################
alb_args = {
    name_tag = "alb"
}

target_group_args = {
    name_tag                    = "target-group"
    health_check_interval       = 10
    health_check_path           = "/health_check/health_check_file"
    health_check_timeout        = 5
    healthy_threshold           = 3
    unhealthy_threshold         = 3
    stickiness_cookie_duration  = 1800
    stickiness_enables          = true
    stickiness_type             = "lb_cookie"
}

listener_name_tag = "linstener"

auto_scaling_args = {
    name                        = "auto-scaling"
    max_size                    = 2
    min_size                    = 1
    health_check_grace_period   = 300
    health_check_type           = "EC2"
    desired_capacity            = 2
}

security_group_for_alb_args = {
    name_tag    = "security-group-for-alb"
    description = "for alb"
}
security_group_ingress_for_alb_args = { 
    name_tag            = "ingress-rule-for-alb"
    ingress_from_port   = 80
    ingress_to_port     = 80
    ingress_protocol    = "tcp"
    ingress_cidr_ipv4   = "xxx.xxx.xxx.xxx/32"# マイIP
}
security_group_egress_for_alb_args = {
    name_tag            = "egress-rule-for-alb"
    egress_from_port    = 0
    egress_to_port      = 0
    egress_protocol     = "-1"
    egress_cidr_ipv4    = "0.0.0.0/0"
}


# RDS ################################################################################################
rds_args = {
    allocated_storage       = 20
    max_allocated_storage   = 200
    storage_type            = "gp3"
    engine                  = "mariadb"
    engine_version          = "10.11"
    instance_class          = "db.t3.micro"
    multi_az                = true
    skip_final_snapshot     = true

    identifier  = "wordpressdb"
    db_name     = "wordpressdb"
    username    = "root"
    password    = "password"
    name_tag    = "db"
}
option_group_args = {
    engine_name             = "mariadb"
    major_engine_version    = "10.11"
    name_tag                = "option-group"
}
parameter_group_args = {
    family                  = "mariadb10.11"
    name_tag                = "parameter-group"
}
subnet_group_name_tag       = "subnet_group"
security_group_for_rds_args = {
    name_tag                = "security-group-for-eds"
    description             = "for rds"
}
security_group_ingress_for_rds_args = {
    name_tag                = "egress-rule-for-rds"
    ingress_from_port       = 3306
    ingress_to_port         = 3306
    ingress_protocol        = "tcp"
    ingress_cidr_ipv4       = null
}
security_group_egress_for_rds_args = {
    name_tag                = "egress-rule-for-rds"
    egress_from_port        = 0
    egress_to_port          = 0
    egress_protocol         = "-1"
    egress_cidr_ipv4        = "0.0.0.0/0"
}
