#!./bin/bash

# yumアップデート
yum update -y

# EFSマウント設定
yum install -y amazon-efs-utils
efs_id="${efs_id}"
mkdir /efs
echo "$efs_id:/ /efs/ efs _netdev,nfsvers=4.1,rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2,noresvport  0 0" >> /etc/fstab
sleep 150
mount -a
mkdir /efs/document_root

# RDS接続用のsqlクライアントのインストール
yum install -y mariadb

# nginxのインストール
yum install -y nginx
systemctl start nginx
systemctl enable nginx

# phpのインストール
yum install -y php php-fpm php-mysqlnd
systemctl start php-fpm
mv /etc/php-fpm.d/www.conf /etc/php-fpm.d/bk-www.conf

# php-fpmの設定
cat < /etc/php-fpm.d/www.conf 
[www]
user = nginx
group = nginx
listen = /run/php-fpm/www.sock
listen.owner = nginx
listen.group = nginx
listen.acl_users = apache,nginx
listen.allowed_clients = 127.0.0.1
pm = dynamic
pm.max_children = 50
pm.start_servers = 5
pm.min_spare_servers = 5
pm.max_spare_servers = 35
slowlog = /var/log/php-fpm/www-slow.log
php_admin_value[error_log] = /var/log/php-fpm/www-error.log
php_admin_flag[log_errors] = on
php_value[session.save_handler] = files
php_value[session.save_path]    = /var/lib/php/session
php_value[soap.wsdl_cache_dir]  = /var/lib/php/wsdlcache
EOF

systemctl restart php-fpm
systemctl enable php-fpm

# wordpressのインストール
wget https://wordpress.org/latest.tar.gz -P /tmp
tar -xzf /tmp/latest.tar.gz -C /tmp/
mv /tmp/wordpress/* /efs/document_root

chown -R nginx:nginx /efs/*

# nginx の設定
cat < /etc/nginx/conf.d/wordpress.conf 
server {
    listen 80;
    server_name _;
    root /efs/document_root/;
    index index.php index.html index.htm;
    location / {
        try_files \$uri \$uri/ /index.php?\$args;
    }
    location ~ \.php$ {
        include /etc/nginx/fastcgi_params;
        fastcgi_pass unix:/run/php-fpm/www.sock;
        fastcgi_index index.php;
        fastcgi_param SCRIPT_FILENAME \$document_root\$fastcgi_script_name;
    }
}
EOF

# ヘルスチェック用ファイルの作成
mkdir /efs/document_root/health_check
touch /efs/document_root/health_check/health_check_file

systemctl restart nginx