<?php get_header(); ?>

<div class="category-page-container">
    <header class="category-header">
        <h1><?php single_cat_title(); ?>記事一覧</h1>
    </header>
    
    <div class="category-grid">
        <?php if (have_posts()) : ?>
            <?php while (have_posts()) : the_post(); ?>
                <div class="category-post-card">
                    <div class="post-thumbnail">
                        <?php if (has_post_thumbnail()) : ?>
                            <a href="<?php the_permalink(); ?>">
                                <?php the_post_thumbnail('medium'); ?>
                            </a>
                        <?php endif; ?>
                    </div>
                    <div class="post-content">
                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                    </div>
                </div>
            <?php endwhile; ?>
        <?php else : ?>
            <p>このカテゴリには記事がありません。</p>
        <?php endif; ?>
    </div>
    
    <div class="pagination">
        <?php the_posts_pagination(); ?>
    </div>
</div>

<style>
.category-page-container {
    max-width: 1200px;
    margin: 40px auto;
    padding: 0 20px;
}

.category-header {
    text-align: center;
    margin-bottom: 40px;
}

.category-header h1 {
    font-size: 2rem;
    color: #333;
}

.pagination {
    margin-top: 40px;
    text-align: center;
}

.pagination .nav-links {
    display: flex;
    justify-content: center;
    gap: 10px;
}

.pagination .nav-links a,
.pagination .nav-links span {
    padding: 8px 16px;
    background-color: #4a5568;
    color: white;
    text-decoration: none;
    border-radius: 5px;
}

.pagination .nav-links .current {
    background-color: #2d3748;
}
</style>

<?php get_footer(); ?>