<?php get_header(); ?>

<div class="single-post-container">
    <?php if (have_posts()) : ?>
        <?php while (have_posts()) : the_post(); ?>
            <article class="single-post">
                <header class="post-header">
                    <h1><?php the_title(); ?></h1>
                    <div class="post-meta">
                        <span>投稿日: <?php the_date(); ?></span>
                        <span>カテゴリ: <?php the_category(', '); ?></span>
                    </div>
                </header>
                
                <?php if (has_post_thumbnail()) : ?>
                    <div class="post-featured-image">
                        <?php the_post_thumbnail('large'); ?>
                    </div>
                <?php endif; ?>
                
                <div class="post-content">
                    <?php the_content(); ?>
                </div>
            </article>
        <?php endwhile; ?>
    <?php endif; ?>
</div>

<style>
.single-post-container {
    max-width: 800px;
    margin: 40px auto;
    padding: 0 20px;
}

.single-post {
    background-color: white;
    border-radius: 15px;
    padding: 40px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}

.post-header h1 {
    font-size: 2rem;
    margin-bottom: 20px;
    color: #333;
}

.post-meta {
    margin-bottom: 30px;
    color: #666;
    font-size: 0.9rem;
}

.post-meta span {
    margin-right: 20px;
}

.post-featured-image {
    margin-bottom: 30px;
}

.post-featured-image img {
    width: 100%;
    height: auto;
    border-radius: 8px;
}

.post-content {
    line-height: 1.6;
    color: #333;
}

.post-content p {
    margin-bottom: 20px;
}
</style>

<?php get_footer(); ?>