<?php //子テーマ用関数
if ( !defined( 'ABSPATH' ) ) exit;

//子テーマ用のビジュアルエディタースタイルを適用
add_editor_style();

//以下に子テーマ用の関数を書く

// Blog-Themeデザイン用のカスタム関数

// カスタムJavaScriptの読み込み
function blog_theme_scripts() {
    wp_enqueue_script('blog-theme-script', get_stylesheet_directory_uri() . '/blog-theme.js', array(), '1.0.0', true);
}
add_action('wp_enqueue_scripts', 'blog_theme_scripts');

// 大きなスライダーは削除

// カテゴリ別投稿表示のショートコード
function blog_theme_category_posts($atts) {
    $atts = shortcode_atts(array(
        'category' => '',
        'title' => '',
        'count' => 6
    ), $atts);
    
    ob_start();
    ?>
    <div class="section">
        <div class="section-header">
            <h2><?php echo esc_html($atts['title']); ?></h2>
        </div>
        <div class="posts-slider">
            <?php
            $posts = new WP_Query(array(
                'category_name' => $atts['category'], 
                'posts_per_page' => $atts['count']
            ));
            if ($posts->have_posts()) :
                while ($posts->have_posts()) : $posts->the_post();
            ?>
                <div class="post-card">
                    <div class="post-thumbnail">
                        <?php if (has_post_thumbnail()) : ?>
                            <?php the_post_thumbnail('thumbnail'); ?>
                        <?php endif; ?>
                    </div>
                    <div class="post-content">
                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                    </div>
                </div>
            <?php endwhile; wp_reset_postdata(); endif; ?>
        </div>
        <div class="section-footer">
            <a href="/category/<?php echo $atts['category']; ?>" class="more-btn">もっと見る</a>
        </div>
    </div>
    <?php
    return ob_get_clean();
}
add_shortcode('blog_category_posts', 'blog_theme_category_posts');

// ボトムナビゲーションのショートコード
function blog_theme_bottom_nav_shortcode() {
    ob_start();
    ?>
    <div class="bottom-nav">
        <div class="nav-box" onclick="location.href='/expert-site'">
            <h3>専門サイト</h3>
        </div>
        <div class="nav-box" onclick="location.href='/tech-site'">
            <h3>技術サイト</h3>
        </div>
        <div class="nav-box" onclick="location.href='/about'">
            <h3>このサイトについて</h3>
        </div>
    </div>
    <?php
    return ob_get_clean();
}
add_shortcode('blog_bottom_nav', 'blog_theme_bottom_nav_shortcode');