<?php get_header(); ?>

<div class="posts-container">
    <div class="section">
        <div class="section-header">
            <h2>最新記事</h2>
        </div>
        <div class="posts-slider">
            <?php
            $latest_posts = new WP_Query(array('posts_per_page' => 8));
            if ($latest_posts->have_posts()) :
                while ($latest_posts->have_posts()) : $latest_posts->the_post();
            ?>
                <div class="post-card">
                    <div class="post-thumbnail">
                        <?php if (has_post_thumbnail()) : ?>
                            <?php the_post_thumbnail('thumbnail'); ?>
                        <?php endif; ?>
                    </div>
                    <div class="post-content">
                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                    </div>
                </div>
            <?php endwhile; wp_reset_postdata(); endif; ?>
        </div>
    </div>

    <div class="section">
        <div class="section-header">
            <h2>クラウド</h2>
        </div>
        <div class="posts-slider">
            <?php
            $cloud_posts = new WP_Query(array('category_name' => 'cloud', 'posts_per_page' => 6));
            if ($cloud_posts->have_posts()) :
                while ($cloud_posts->have_posts()) : $cloud_posts->the_post();
            ?>
                <div class="post-card">
                    <div class="post-thumbnail">
                        <?php if (has_post_thumbnail()) : ?>
                            <?php the_post_thumbnail('thumbnail'); ?>
                        <?php endif; ?>
                    </div>
                    <div class="post-content">
                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                    </div>
                </div>
            <?php endwhile; wp_reset_postdata(); endif; ?>
        </div>
        <div class="section-footer">
            <a href="/category/cloud" class="more-btn">もっと見る</a>
        </div>
    </div>

    <div class="section">
        <div class="section-header">
            <h2>ソリューション</h2>
        </div>
        <div class="posts-slider">
            <?php
            $solution_posts = new WP_Query(array('category_name' => 'solution', 'posts_per_page' => 6));
            if ($solution_posts->have_posts()) :
                while ($solution_posts->have_posts()) : $solution_posts->the_post();
            ?>
                <div class="post-card">
                    <div class="post-thumbnail">
                        <?php if (has_post_thumbnail()) : ?>
                            <?php the_post_thumbnail('thumbnail'); ?>
                        <?php endif; ?>
                    </div>
                    <div class="post-content">
                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                    </div>
                </div>
            <?php endwhile; wp_reset_postdata(); endif; ?>
        </div>
        <div class="section-footer">
            <a href="/category/solution" class="more-btn">もっと見る</a>
        </div>
    </div>

    <div class="section">
        <div class="section-header">
            <h2>プロダクト</h2>
        </div>
        <div class="posts-slider">
            <?php
            $product_posts = new WP_Query(array('category_name' => 'product', 'posts_per_page' => 6));
            if ($product_posts->have_posts()) :
                while ($product_posts->have_posts()) : $product_posts->the_post();
            ?>
                <div class="post-card">
                    <div class="post-thumbnail">
                        <?php if (has_post_thumbnail()) : ?>
                            <?php the_post_thumbnail('thumbnail'); ?>
                        <?php endif; ?>
                    </div>
                    <div class="post-content">
                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                    </div>
                </div>
            <?php endwhile; wp_reset_postdata(); endif; ?>
        </div>
        <div class="section-footer">
            <a href="/category/product" class="more-btn">もっと見る</a>
        </div>
    </div>

    <div class="section">
        <div class="section-header">
            <h2>イベント情報</h2>
        </div>
        <div class="posts-slider">
            <?php
            $event_posts = new WP_Query(array('category_name' => 'event', 'posts_per_page' => 6));
            if ($event_posts->have_posts()) :
                while ($event_posts->have_posts()) : $event_posts->the_post();
            ?>
                <div class="post-card">
                    <div class="post-thumbnail">
                        <?php if (has_post_thumbnail()) : ?>
                            <?php the_post_thumbnail('thumbnail'); ?>
                        <?php endif; ?>
                    </div>
                    <div class="post-content">
                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                    </div>
                </div>
            <?php endwhile; wp_reset_postdata(); endif; ?>
        </div>
        <div class="section-footer">
            <a href="/category/event" class="more-btn">もっと見る</a>
        </div>
    </div>

    <div class="section">
        <div class="section-header">
            <h2>人材紹介</h2>
        </div>
        <div class="posts-slider">
            <?php
            $recruitment_posts = new WP_Query(array('category_name' => 'recruitment', 'posts_per_page' => 6));
            if ($recruitment_posts->have_posts()) :
                while ($recruitment_posts->have_posts()) : $recruitment_posts->the_post();
            ?>
                <div class="post-card">
                    <div class="post-thumbnail">
                        <?php if (has_post_thumbnail()) : ?>
                            <?php the_post_thumbnail('thumbnail'); ?>
                        <?php endif; ?>
                    </div>
                    <div class="post-content">
                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                    </div>
                </div>
            <?php endwhile; wp_reset_postdata(); endif; ?>
        </div>
        <div class="section-footer">
            <a href="/category/recruitment" class="more-btn">もっと見る</a>
        </div>
    </div>

    <div class="section">
        <div class="section-header">
            <h2>セミナー情報</h2>
        </div>
        <div class="posts-slider">
            <?php
            $seminar_posts = new WP_Query(array('category_name' => 'seminar', 'posts_per_page' => 6));
            if ($seminar_posts->have_posts()) :
                while ($seminar_posts->have_posts()) : $seminar_posts->the_post();
            ?>
                <div class="post-card">
                    <div class="post-thumbnail">
                        <?php if (has_post_thumbnail()) : ?>
                            <?php the_post_thumbnail('thumbnail'); ?>
                        <?php endif; ?>
                    </div>
                    <div class="post-content">
                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                    </div>
                </div>
            <?php endwhile; wp_reset_postdata(); endif; ?>
        </div>
        <div class="section-footer">
            <a href="/category/seminar" class="more-btn">もっと見る</a>
        </div>
    </div>
</div>

<div class="bottom-nav">
    <div class="nav-box" onclick="location.href='/expert-site'">
        <h3>専門サイト</h3>
    </div>
    <div class="nav-box" onclick="location.href='/tech-site'">
        <h3>技術サイト</h3>
    </div>
    <div class="nav-box" onclick="location.href='/about'">
        <h3>このサイトについて</h3>
    </div>
</div>

<?php get_footer(); ?>