add_action('admin_footer-post.php', 'ai_checker_snippet_output');
add_action('admin_footer-post-new.php', 'ai_checker_snippet_output');
function ai_checker_snippet_output() {
    // JSとAjax返却部分一括で出力
    $nonce = wp_create_nonce('ai_checker_snip');
    ?>
    <script>
    jQuery(function($){
        function showAIChecker() {
            var content = $("#content").val();
            $("#ai_post_check_result").remove();
            var $result = $('<div id="ai_post_check_result" style="border:1px solid #ccc;padding:10px;margin:10px 0;"><strong>AIチェック中...</strong></div>');
            $('#post-preview').after($result);

            $.post(ajaxurl, {
                action: 'ai_checker_snippet_ajax',
                ai_content: content,
                _ajax_nonce: "<?php echo $nonce; ?>"
            }, function(res){
                if(res.success) {
                    $result.html('<strong>AIコメント:</strong> ' + res.data);
                } else {
                    $result.html('<strong>エラー:</strong> ' + res.data);
                }
            });
        }

        $('#post-preview').on('click', showAIChecker);
    });
    </script>
    <?php
}

// Ajax通信部分
add_action('wp_ajax_ai_checker_snippet_ajax', function() {
    check_ajax_referer('ai_checker_snip');
    $content = sanitize_text_field($_POST['ai_content'] ?? '');
    if (!$content) wp_send_json_error('本文が空です');

    // ----- ここにAI APIリクエスト処理 -----
    $api_key = '【ここにOpenAI APIキー】'; //例: wp-config.phpで管理推奨
    $prompt = "以下の文章について、正式名称が使われているかと、文章体裁が保たれているか判定し短くコメントしてください:\n\n{$content}";
    $api_response = wp_remote_post('https://api.openai.com/v1/chat/completions', [
        'headers' => [
            'Authorization' => 'Bearer ' . $api_key,
            'Content-Type' => 'application/json'
        ],
        'body' => json_encode([
            "model" => "gpt-3.5-turbo",
            "messages" => [["role" => "user", "content" => $prompt]],
            "max_tokens" => 100
        ]),
        'timeout' => 15,
    ]);
    if(is_wp_error($api_response)) wp_send_json_error('AI APIエラー');
    $json = json_decode(wp_remote_retrieve_body($api_response), true);
    $ai_comment = $json['choices'][0]['message']['content'] ?? '解析不可';
    wp_send_json_success($ai_comment);
});