# Cocoon Child Theme - Blog-Theme Design Integration

## 概要
CocoonテーマをBlog-Themaのデザインに変更したカスタム子テーマです。
既存のCocoon子テーマの構造を保持したまま、Blog-Themeの機能を統合しています。

## 変更・追加されたファイル

### 変更されたファイル
1. **style.css** - Blog-Themeのデザインスタイルを追加（15行目〜166行目）
2. **functions.php** - カスタム機能とショートコードを追加（7行目〜68行目）
3. **javascript.js** - ドラッグスクロール機能を追加（既存のコメント後に追加）

### 新規追加されたファイル
1. **front-page.php** - Blog-Themeレイアウトのフロントページテンプレート
2. **lib/blog-theme/** - Blog-Theme機能のライブラリファイル群
   - **blog-theme-core.php** - メインコアライブラリ
   - **includes/shortcodes.php** - ショートコード機能
   - **includes/utilities.php** - ユーティリティ関数
   - **includes/template-functions.php** - テンプレート関数
   - **assets/blog-theme-lib.css** - ライブラリ用追加CSS

### 保持されたファイル
- **amp.css** - AMP用スタイル（既存のまま）
- **editor-style.css** - エディタースタイル（既存のまま）
- **keyframes.css** - アニメーション用CSS（既存のまま）
- **screenshot.jpg** - テーマスクリーンショット（既存のまま）
- **skins/** - スキンテンプレート（既存のまま）
- **tmp-user/** - ユーザー用テンプレート（既存のまま）

## 主な機能
- カード型の投稿デザイン
- カテゴリ別投稿スライダー（ドラッグスクロール対応）
- ボトムナビゲーション
- レスポンシブ対応
- Cocoonの既存機能との完全互換性

## インストール方法
1. 既存の `wp-content/themes/cocoon-child-master/` フォルダをバックアップ
2. このフォルダの内容で既存のCocoon子テーマを置き換え
3. WordPress管理画面で「Cocoon Child」テーマを有効化

## 推奨カテゴリ設定
以下のカテゴリを作成することで、フロントページが最適に表示されます：
- cloud（クラウド）
- solution（ソリューション）
- product（プロダクト）
- event（イベント情報）
- recruitment（人材紹介）
- seminar（セミナー情報）

## 利用可能なショートコード
- `[blog_category_posts category="カテゴリ名" title="タイトル" count="6"]` - カテゴリ別投稿表示
- `[blog_bottom_nav]` - ボトムナビゲーション

## 注意事項
- ヘッダーとフッターはCocoonのデフォルトデザインを使用
- 投稿にアイキャッチ画像を設定することを推奨
- 既存のCocoon機能（AMP、スキン、カスタマイザーなど）はすべて利用可能

## 技術仕様
- WordPress 5.0以上対応
- PHP 7.4以上対応
- Cocoon親テーマ必須
- レスポンシブデザイン対応

## 更新履歴
- 2025/10/26: 初回リリース - Blog-Themeデザインの統合

## サポート
このテーマはCocoon公式テーマの子テーマとして作成されています。
Cocoonの基本機能に関する質問は、Cocoon公式サポートをご利用ください。