<?php
/**
 * Blog-Theme Core Library
 * 
 * @package Cocoon Child
 * @subpackage Blog-Theme
 * @version 1.0.0
 */

if (!defined('ABSPATH')) {
    exit;
}

class BlogThemeCore {
    
    /**
     * Initialize Blog-Theme functionality
     */
    public static function init() {
        add_action('wp_enqueue_scripts', array(__CLASS__, 'enqueue_styles'));
        add_action('init', array(__CLASS__, 'register_shortcodes'));
        add_action('wp_head', array(__CLASS__, 'add_meta_tags'));
    }
    
    /**
     * Enqueue Blog-Theme specific styles
     */
    public static function enqueue_styles() {
        // Blog-Theme library styles
        wp_enqueue_style(
            'blog-theme-lib-css',
            get_stylesheet_directory_uri() . '/lib/blog-theme/assets/blog-theme-lib.css',
            array(),
            '1.0.0'
        );
    }
    
    /**
     * Register all Blog-Theme shortcodes
     */
    public static function register_shortcodes() {
        require_once get_stylesheet_directory() . '/lib/blog-theme/includes/shortcodes.php';
        BlogThemeShortcodes::init();
    }
    
    /**
     * Add Blog-Theme specific meta tags
     */
    public static function add_meta_tags() {
        echo '<meta name="blog-theme-version" content="1.0.0">' . "\n";
    }
    
    /**
     * Get post cards HTML for a specific category
     * 
     * @param string $category Category slug
     * @param int $count Number of posts to retrieve
     * @return string HTML output
     */
    public static function get_category_posts_html($category, $count = 6) {
        $posts = new WP_Query(array(
            'category_name' => $category,
            'posts_per_page' => $count,
            'post_status' => 'publish'
        ));
        
        ob_start();
        
        if ($posts->have_posts()) :
            while ($posts->have_posts()) : $posts->the_post();
                ?>
                <div class="post-card">
                    <div class="post-thumbnail">
                        <?php if (has_post_thumbnail()) : ?>
                            <?php the_post_thumbnail('thumbnail'); ?>
                        <?php else : ?>
                            <div class="no-thumbnail"></div>
                        <?php endif; ?>
                    </div>
                    <div class="post-content">
                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                    </div>
                </div>
                <?php
            endwhile;
            wp_reset_postdata();
        else :
            echo '<p class="no-posts">投稿が見つかりませんでした。</p>';
        endif;
        
        return ob_get_clean();
    }
    
    /**
     * Get latest posts HTML
     * 
     * @param int $count Number of posts to retrieve
     * @return string HTML output
     */
    public static function get_latest_posts_html($count = 8) {
        $posts = new WP_Query(array(
            'posts_per_page' => $count,
            'post_status' => 'publish'
        ));
        
        ob_start();
        
        if ($posts->have_posts()) :
            while ($posts->have_posts()) : $posts->the_post();
                ?>
                <div class="post-card">
                    <div class="post-thumbnail">
                        <?php if (has_post_thumbnail()) : ?>
                            <?php the_post_thumbnail('thumbnail'); ?>
                        <?php else : ?>
                            <div class="no-thumbnail"></div>
                        <?php endif; ?>
                    </div>
                    <div class="post-content">
                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                    </div>
                </div>
                <?php
            endwhile;
            wp_reset_postdata();
        else :
            echo '<p class="no-posts">投稿が見つかりませんでした。</p>';
        endif;
        
        return ob_get_clean();
    }
}

// Initialize Blog-Theme Core
BlogThemeCore::init();