<?php
/**
 * Blog-Theme Shortcodes Library
 * 
 * @package Cocoon Child
 * @subpackage Blog-Theme
 * @version 1.0.0
 */

if (!defined('ABSPATH')) {
    exit;
}

class BlogThemeShortcodes {
    
    /**
     * Initialize shortcodes
     */
    public static function init() {
        add_shortcode('blog_category_posts', array(__CLASS__, 'category_posts_shortcode'));
        add_shortcode('blog_bottom_nav', array(__CLASS__, 'bottom_nav_shortcode'));
        add_shortcode('blog_latest_posts', array(__CLASS__, 'latest_posts_shortcode'));
    }
    
    /**
     * Category posts shortcode
     */
    public static function category_posts_shortcode($atts) {
        $atts = shortcode_atts(array(
            'category' => '',
            'title' => '',
            'count' => 6,
            'show_more' => 'true'
        ), $atts);
        
        if (empty($atts['category'])) {
            return '<p class="error">カテゴリが指定されていません。</p>';
        }
        
        ob_start();
        ?>
        <div class="section">
            <?php if (!empty($atts['title'])) : ?>
            <div class="section-header">
                <h2><?php echo esc_html($atts['title']); ?></h2>
            </div>
            <?php endif; ?>
            <div class="posts-slider">
                <?php echo BlogThemeCore::get_category_posts_html($atts['category'], intval($atts['count'])); ?>
            </div>
            <?php if ($atts['show_more'] === 'true') : ?>
            <div class="section-footer">
                <a href="/category/<?php echo esc_attr($atts['category']); ?>" class="more-btn">もっと見る</a>
            </div>
            <?php endif; ?>
        </div>
        <?php
        return ob_get_clean();
    }
    
    /**
     * Latest posts shortcode
     */
    public static function latest_posts_shortcode($atts) {
        $atts = shortcode_atts(array(
            'title' => '最新記事',
            'count' => 8
        ), $atts);
        
        ob_start();
        ?>
        <div class="section">
            <div class="section-header">
                <h2><?php echo esc_html($atts['title']); ?></h2>
            </div>
            <div class="posts-slider">
                <?php echo BlogThemeCore::get_latest_posts_html(intval($atts['count'])); ?>
            </div>
        </div>
        <?php
        return ob_get_clean();
    }
    
    /**
     * Bottom navigation shortcode
     */
    public static function bottom_nav_shortcode($atts) {
        $atts = shortcode_atts(array(
            'nav1_title' => '専門サイト',
            'nav1_url' => '/expert-site',
            'nav2_title' => '技術サイト',
            'nav2_url' => '/tech-site',
            'nav3_title' => 'このサイトについて',
            'nav3_url' => '/about'
        ), $atts);
        
        ob_start();
        ?>
        <div class="bottom-nav">
            <div class="nav-box" onclick="location.href='<?php echo esc_url($atts['nav1_url']); ?>'">
                <h3><?php echo esc_html($atts['nav1_title']); ?></h3>
            </div>
            <div class="nav-box" onclick="location.href='<?php echo esc_url($atts['nav2_url']); ?>'">
                <h3><?php echo esc_html($atts['nav2_title']); ?></h3>
            </div>
            <div class="nav-box" onclick="location.href='<?php echo esc_url($atts['nav3_url']); ?>'">
                <h3><?php echo esc_html($atts['nav3_title']); ?></h3>
            </div>
        </div>
        <?php
        return ob_get_clean();
    }
}