<?php
/**
 * Blog-Theme Utilities Library
 * 
 * @package Cocoon Child
 * @subpackage Blog-Theme
 * @version 1.0.0
 */

if (!defined('ABSPATH')) {
    exit;
}

class BlogThemeUtilities {
    
    /**
     * Get category by slug
     */
    public static function get_category_by_slug($slug) {
        return get_term_by('slug', $slug, 'category');
    }
    
    /**
     * Check if category exists
     */
    public static function category_exists($slug) {
        return self::get_category_by_slug($slug) !== false;
    }
    
    /**
     * Get post thumbnail URL or default
     */
    public static function get_post_thumbnail_url($post_id = null, $size = 'thumbnail') {
        if (!$post_id) {
            $post_id = get_the_ID();
        }
        
        $thumbnail_url = get_the_post_thumbnail_url($post_id, $size);
        
        if (!$thumbnail_url) {
            return get_stylesheet_directory_uri() . '/lib/blog-theme/assets/default-thumbnail.png';
        }
        
        return $thumbnail_url;
    }
    
    /**
     * Truncate text to specified length
     */
    public static function truncate_text($text, $length = 100, $suffix = '...') {
        if (mb_strlen($text) <= $length) {
            return $text;
        }
        
        return mb_substr($text, 0, $length) . $suffix;
    }
    
    /**
     * Get social share URL
     */
    public static function get_social_share_url($platform, $url = null, $title = null) {
        if (!$url) {
            $url = get_permalink();
        }
        
        if (!$title) {
            $title = get_the_title();
        }
        
        $encoded_url = urlencode($url);
        $encoded_title = urlencode($title);
        
        switch ($platform) {
            case 'twitter':
                return "https://twitter.com/intent/tweet?url={$encoded_url}&text={$encoded_title}";
            
            case 'facebook':
                return "https://www.facebook.com/sharer/sharer.php?u={$encoded_url}";
            
            case 'line':
                return "https://social-plugins.line.me/lineit/share?url={$encoded_url}";
            
            default:
                return '';
        }
    }
}