# Test Environment for Apex Domain Redirect System

このドキュメントは、Apex Domain Redirect System のテスト環境について説明します。

## 概要

テスト環境は、CloudFront + S3 構成で構築されたサンプルWebサイトです。メインのApex Domain Redirect System のリダイレクト先として使用し、動作確認を行うことができます。

## 要件対応

- **Optional 1.1**: CloudFront + S3バケット構成で作成
- **Optional 1.2**: サンプルWebサイトのトップページを提供
- **Optional 1.3**: CloudFrontのデフォルトドメインを使用
- **Optional 1.4**: S3バケットにランダムな文字列をsuffixとして含む名前
- **Optional 1.5**: メインシステムとは独立したCloudFormationテンプレート

## ファイル構成

```
apexdomain/
├── test-environment.yaml          # テスト環境用CloudFormationテンプレート
├── deploy_test_environment.sh     # デプロイスクリプト
└── TEST_ENVIRONMENT_README.md     # このファイル
```

## デプロイ方法

### 1. 自動デプロイ（推奨）

```bash
# テスト環境をデプロイ
./apexdomain/deploy_test_environment.sh deploy

# スタックの状態確認
./apexdomain/deploy_test_environment.sh status

# テスト環境を削除
./apexdomain/deploy_test_environment.sh cleanup
```

### 2. 手動デプロイ

```bash
# CloudFormationテンプレートの検証
aws cloudformation validate-template \
    --template-body file://apexdomain/test-environment.yaml \
    --profile your-aws-profile-name \
    --region ap-northeast-1

# スタックの作成
aws cloudformation create-stack \
    --stack-name kodama-apexdomain-test-env \
    --template-body file://apexdomain/test-environment.yaml \
    --capabilities CAPABILITY_NAMED_IAM \
    --parameters \
        ParameterKey=ResourcePrefix,ParameterValue=kodama-apexdomain-test \
        ParameterKey=CostTag,ParameterValue=j.kodama \
        ParameterKey=CreateDate,ParameterValue=$(date +%Y/%m/%d) \
    --profile your-aws-profile-name \
    --region ap-northeast-1

# デプロイ完了まで待機
aws cloudformation wait stack-create-complete \
    --stack-name kodama-apexdomain-test-env \
    --profile your-aws-profile-name \
    --region ap-northeast-1
```

## 構成要素

### 1. S3 Bucket
- **名前**: `kodama-apexdomain-test-website-{AccountId}-{Region}`
- **用途**: 静的Webサイトのコンテンツ保存
- **セキュリティ**: Origin Access Control (OAC) による制限付きアクセス

### 2. CloudFront Distribution
- **用途**: グローバルコンテンツ配信
- **設定**: 
  - HTTPS リダイレクト有効
  - Gzip圧縮有効
  - デフォルトルートオブジェクト: `index.html`
  - カスタムエラーページ: `404.html`

### 3. Sample HTML Files
- **index.html**: メインページ（テスト環境の情報表示）
- **sample.html**: サンプルページ（リダイレクトテスト用）
- **404.html**: エラーページ

## 使用方法

### 1. テスト環境の確認

デプロイ完了後、以下の情報が出力されます：

```
CloudFront Domain: d1234567890123.cloudfront.net
Test Website URL:  https://d1234567890123.cloudfront.net
```

### 2. メインシステムとの連携

メインのApex Domain Redirect System をデプロイする際、`RedirectTargetFQDN` パラメータにCloudFrontドメインを指定します：

```bash
aws cloudformation create-stack \
    --stack-name kodama-apexdomain-main \
    --template-body file://apexdomain/apex-domain-redirect.yaml \
    --parameters \
        ParameterKey=ApexDomain,ParameterValue=example.com \
        ParameterKey=RedirectTargetFQDN,ParameterValue=d1234567890123.cloudfront.net \
        # その他のパラメータ...
```

### 3. 動作テスト

1. **テスト環境の確認**:
   ```bash
   curl -I https://d1234567890123.cloudfront.net
   ```

2. **リダイレクト動作の確認**:
   - Apexドメインにアクセス
   - 10秒後にテスト環境に自動転送されることを確認

## トラブルシューティング

### CloudFrontの配信に時間がかかる場合

CloudFrontの配信開始には5-10分程度かかる場合があります。デプロイ直後にアクセスできない場合は、しばらく待ってから再度アクセスしてください。

### S3バケット名の重複エラー

S3バケット名は全世界で一意である必要があります。エラーが発生した場合は、`BucketSuffix` パラメータを変更してください：

```bash
--parameters \
    ParameterKey=BucketSuffix,ParameterValue=unique-suffix-123 \
    # その他のパラメータ...
```

### Lambda関数のタイムアウト

サンプルファイルの作成でタイムアウトが発生した場合は、CloudFormationスタックを削除して再作成してください。

## セキュリティ考慮事項

- S3バケットはパブリックアクセスをブロック
- CloudFrontからのアクセスのみ許可（OAC使用）
- HTTPS通信を強制
- 適切なセキュリティヘッダーを設定

## コスト最適化

- CloudFrontの価格クラスを `PriceClass_100` に設定（北米・ヨーロッパのみ）
- S3のライフサイクルポリシーを設定
- 不要になったら必ずスタックを削除

## 参考URL

- [AWS CloudFormation Template Reference - CloudFront Distribution](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-properties-cloudfront-distribution-origin.html)
- [AWS CloudFormation Template Reference - S3OriginConfig](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-properties-cloudfront-distribution-s3originconfig.html)
- [Tutorial: Configuring a static website on Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/userguide/HostingWebsiteOnS3Setup.html)
- [Hosting a static website using Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html)